import jenkins.model.*
import hudson.security.*

def varName = args[0]
def varValue =  args[1]
def env = System.getenv()

if( varValue.toString().startsWith(env['HOME'])){
  println ("convert path back to tilde")
  varValue = varValue.replace(env['HOME'], "~" )
 }
if( varValue.toString().startsWith(File.separator + "root" + File.separator)){
  println ("convert path back to tilde")
  varValue = varValue.replace(File.separator + "root" + File.separator, "~" + File.separator)
}

def instance = Jenkins.getInstance()
def globalNodeProperties = instance.getGlobalNodeProperties()
def envVarsNodePropertyList = globalNodeProperties.getAll(hudson.slaves.EnvironmentVariablesNodeProperty.class)

def newEnvVarsNodeProperty = null
def envVars = null

if ( envVarsNodePropertyList == null || envVarsNodePropertyList.size() == 0 ) {
  newEnvVarsNodeProperty = new hudson.slaves.EnvironmentVariablesNodeProperty();
  globalNodeProperties.add(newEnvVarsNodeProperty)
  envVars = newEnvVarsNodeProperty.getEnvVars()
} else {
  envVars = envVarsNodePropertyList.get(0).getEnvVars()

}
println(envVars)

println ("Adding/Updating " + varName + ":" + varValue)

envVars.put(varName, varValue)

println( envVarsNodePropertyList.get(0).getEnvVars())

instance.save()